// Header File
// Created 6/20/2010; 12:34:14 AM

#ifndef _pryamid_h
#define _pyramid_h


#include "BasicTypes.h"


#define MAX_NUM_CARDS     52
#define PYRAMID_NUM_CARDS 28
#define INVALID_INDEX     -1
#define INVALID_VALUE      0
#define GAME_AUTOTIMER    0x40000
#define TITLE_AUTOTIMER   0x40000

typedef struct
{
	int2 value;
	int2 x;
	int2 y;
	int1 parent1;
	int1 parent2;
	int1 child1;
	int1 child2;
	int1 graph_x;
	int1 graph_y;
} Node_Type;


static Node_Type pyramid_node[28] =
{
	{ 0, 72,  4, -1, -1,  1,  2, 16,  4},
	{ 0, 62, 15, -1,  0,  3,  4, 14,  8},
	{ 0, 82, 15,  0, -1,  4,  5, 18,  8},
	{ 0, 52, 26, -1,  1,  6,  7, 12, 12},
	{ 0, 72, 26,  1,  2,  7,  8, 16, 12},
	{ 0, 92, 26,  2, -1,  8,  9, 20, 12},
	{ 0, 42, 37, -1,  3, 10, 11, 10, 16},
	{ 0, 62, 37,  3,  4, 11, 12, 14, 16},
	{ 0, 82, 37,  4,  5, 12, 13, 18, 16},
	{ 0,102, 37,  5, -1, 13, 14, 22, 16},
	{ 0, 32, 48, -1,  6, 15, 16,  8, 20},
	{ 0, 52, 48,  6,  7, 16, 17, 12, 20},
	{ 0, 72, 48,  7,  8, 17, 18, 16, 20},
	{ 0, 92, 48,  8,  9, 18, 19, 20, 20},
	{ 0,112, 48,  9, -1, 19, 20, 24, 20},
	{ 0, 22, 59, -1, 10, 21, 22,  6, 24},
	{ 0, 42, 59, 10, 11, 22, 23, 10, 24},
	{ 0, 62, 59, 11, 12, 23, 24, 14, 24},
	{ 0, 82, 59, 12, 13, 24, 25, 18, 24},
	{ 0,102, 59, 13, 14, 25, 26, 22, 24},
	{ 0,122, 59, 14, -1, 26, 27, 26, 24},
	{ 0, 12, 70, -1, 15, -1, -1,  4, 28},
	{ 0, 32, 70, 15, 16, -1, -1,  8, 28},
	{ 0, 52, 70, 16, 17, -1, -1, 12, 28},
	{ 0, 72, 70, 17, 18, -1, -1, 16, 28},
	{ 0, 92, 70, 18, 19, -1, -1, 20, 28},
	{ 0,112, 70, 19, 20, -1, -1, 24, 28},
	{ 0,132, 70, 20, -1, -1, -1, 28, 28}
};


typedef enum
{
	DIR_None = 0,
	DIR_Up,
	DIR_Right,
	DIR_Down,
	DIR_Left,
	DIR_Total
} DIR_Type;



#endif